const OldValue = require('../old-value');
const Value = require('../value');

class Pixelated extends Value {

    /**
     * Use non-standard name for WebKit and Firefox
     */
    replace(string, prefix) {
        if (prefix === '-webkit-') {
            return string.replace(this.regexp(), '$1-webkit-optimize-contrast');
        } else if (prefix === '-moz-') {
            return string.replace(this.regexp(), '$1-moz-crisp-edges');
        } else {
            return super.replace(string, prefix);
        }
    }

    /**
     * Different name for WebKit and Firefox
     */
    old(prefix) {
        if (prefix === '-webkit-') {
            return new OldValue(this.name, '-webkit-optimize-contrast');
        } else if (prefix === '-moz-') {
            return new OldValue(this.name, '-moz-crisp-edges');
        } else {
            return super.old(prefix);
        }
    }

}

Pixelated.names = ['pixelated'];
module.exports = Pixelated;