const Declaration = require('../declaration');

class WritingMode extends Declaration {

    set(decl, prefix) {
        if (prefix === '-ms-') {
            decl.value = WritingMode.msValues[decl.value] || decl.value;
            return super.set(decl, prefix);
        } else {
            return super.set(decl, prefix);
        }
    }

}

WritingMode.names = ['writing-mode'];
WritingMode.msValues = {
    'horizontal-tb': 'lr-tb',
    'vertical-rl': 'tb-rl',
    'vertical-lr': 'tb-lr'
};
module.exports = WritingMode;