var CoffeeScript = loadLibrary('coffee-script');

compiler.compileWithContext = function(context, outError)
{
 	try {
		var compiled = CoffeeScript.compile(context.text, {
			bare: true,
			sourceMap: true,
			sourceFiles: [context.sourcePath]
		});
		
		context.didCompileToText(compiled.js);
		context.didBuildSourceMap(compiled.v3SourceMap);
	}
	catch (error) {
		
		var errorInfo = {};
		
		// Find the error range
		if (error.location && error.location.first_line !== undefined) {
			var lineStorage = context.textContext.lineStorage;
			var lineRange = lineStorage.lineRangeForLineNumber(parseInt(error.location.first_line + 1, 10));
			var errorRange = new Range(lineRange.location, 0);
			
			if (error.location.first_column !== undefined) {
				errorRange.location += error.location.first_column + 1;
				
				// Only select text if it doesn't jump to an additional line
				if (error.location.last_line === undefined && error.location.last_column !== undefined) {
					errorRange.length = error.location.last_column - error.location.first_column;
				}
			}
			
			errorInfo[EBCompilerErrorRangeKey] = errorRange;
		}
		
		context.didFailWithError(EBCompilerErrorParsing, error.message, errorInfo);
		
		return false;
	}
	
	return true;
};

