(function() {
	var exports = {};
	
	exports.update = function(data)
	{
		compressionSettings.update(data);
	};
	
	exports.prepareForReuse = function()
	{
		compressionSettings.prepareForReuse();
	};
	
	window.ui = exports;
	
	var compressionSettings = {
		
		form: document.querySelector('form'),
		pathsList: document.querySelector('#paths'),
		mangleOption: document.querySelector('form input[name=mangle]'),
		compressOption: document.querySelector('form input[name=compress]'),
		outsideDynamoWarning: document.querySelector('#outsideDynamo'),
		
		noPathsHTML: (document.querySelector('#paths #empty') || {}).outerHTML || '',
		
		init: function()
		{
			// Auto-updating/saving
			var formDidChange = function() { compressionSettings.formDidChange(); return true; };
			
			this.compressOption.onchange = formDidChange;
			this.mangleOption.onchange = formDidChange;
			
			this.prepareForReuse();
		},
		
		prepareForReuse: function()
		{
			this.pathsList.innerHTML = '';
			this.mangleOption.checked = false;
			this.compressOption.checked = false;
		},
		
		update: function(data)
		{
			// Normalize data
			data = data || {};
			data.paths = data.paths || [];
			
			data.recipe = data.recipe || {};
			data.recipe.paths = data.recipe.paths || [];
			data.recipe.mangle = (data.recipe.mangle !== undefined) ? data.recipe.mangle : true;
			data.recipe.compress = !!data.recipe.compress;
			
			// Build paths checklist
			if ((data.paths.length + data.recipe.paths.length) === 0) {
				this.pathsList.innerHTML = this.noPathsHTML;
			}
			else {
				var paths = utils.dedupe(data.paths.concat(data.recipe.paths)).sort();
				var pathIndex = 0;
								
				this.pathsList.innerHTML = '';
				
				paths.forEach(function(path) {
					var pathID = 'p' + pathIndex;
					var checked = (data.recipe.paths.indexOf(path) !== -1) ? ' checked="true"' : '';
					
					var pathItem = document.createElement('li');
					pathItem.innerHTML = '<input type="checkbox" id="' + pathID + '" ' + checked + ' value="' + path + '"/><label for="' + pathID + '">' + path + '</label>';
					
					pathItem.onchange = function() {
						compressionSettings.formDidChange();
					};
					
					this.pathsList.appendChild(pathItem);
					pathIndex++;
				}, this);
			}
			
			// Update UI
			utils.applyValuesToForm(this.form, data.recipe);
			
			if (data.isOutsideOfBuildFolder) {
				utils.show(this.outsideDynamoWarning);
			}
			else {
				utils.hide(this.outsideDynamoWarning);
			}
		},
		
		appendFiles: function(files)
		{
			// Get our paths from our map
			var paths = utils.dedupe(this.pathsFromList().concat(files));
			
			// Update the paths input
			var pathsInputString = paths.join('\n');
			if (pathsInputString !== this.pathsInput.value) {
				this.pathsInput.focus();
				this.pathsInput.value = paths.join('\n');
				
				// Update selection range and scroll to the bottom
				this.pathsInput.setSelectionRange(this.pathsInput.value.length, this.pathsInput.value.length);
				this.pathsInput.scrollTop = 999999;
				
				this.formDidChange();			
			}
		},
		
		pathsFromList: function()
		{
			var paths = [];
			var checkedPathNodes = this.pathsList.querySelectorAll('input[type="checkbox"]:checked');
			
			// checkedPathNodes != array
			for (var i = 0; i < checkedPathNodes.length; i++) {
				paths.push(checkedPathNodes[i].value);
			}
			
			return paths;
		},
		
		formDidChange: function()
		{
			var data = utils.formToDictValue(this.form);
			data.paths = this.pathsFromList();
			
			bridge.send('saveRecipe', data, function(response) {
				if (response) {
					ui.update(response);
				}
			});
		}
	};
	
	compressionSettings.init();
})();