(function() {
	
	var utils = {};
		
	// DOM
	
	utils.show = function(element)
	{
		element.style.display = 'block';
	};
	
	utils.hide = function(element)
	{
		element.style.display = 'none';
	};
	
	utils.isVisible = function(element)
	{
		var isVisible = !!element;
		var currentElement = element;
		
		while (currentElement && isVisible) {
			isVisible = currentElement.style ? currentElement.style.display !== 'none' : true;
			currentElement = currentElement.parentNode;
		}
		
		return isVisible;
	};
	
	utils.enable = function(element)
	{
		element.removeAttribute('disabled');
	};
	
	utils.disable = function(element)
	{
		element.setAttribute('disabled', true);
	};
	
	utils.isDisabled = function(element)
	{
		return element.hasAttribute('disabled');
	};
	
	utils.formToDictValue = function(form)
	{
		var dictValue = {};
		var elements = form ? form.querySelectorAll('input, select') : [];
		
		for (var elementIndex = 0; elementIndex < elements.length; elementIndex++) {
			var element = elements[elementIndex];
			
			if (element.type === 'submit' || element.type === "button" || (element.type === "radio" && !element.checked)) {
				continue;
			}
			
			var name = element.name || '';
			if (name.length === 0) {
				continue;
			}
			
			if (element.type === 'checkbox') {
				if (element.getAttribute('value')) {
					if (element.checked) {
						dictValue[name] = element.value;
					}
				}
				else {
					dictValue[name] = element.checked;
				}
			}
			else if ((element.value || '').length > 0) {
				dictValue[name] = element.value;
			}
		}
		
		return dictValue;
	};
	
	utils.applyValuesToForm = function (form, values)
	{
		if (form === null) {
			return;
		}
		
		values = values || {};
		
		for (var name in values) {
			var element = form.querySelector('[name="' + name + '"]');
			
			if (element) {
				var value = values[name];
				
				if (element.type === 'radio') {
					var radioElement = form.querySelector('[name="' + name + '"][value="' + (value || '') + '"]');
					(radioElement || element).checked = true;
				}
				else if (element.type === 'checkbox') {
					element.checked = value;
				}
				else {
					element.value = value;
				}
			}
		}
	};
	
	// Misc
	
	utils.dedupe = function(array)
	{
		array = array || [];
		
		var map = {};
		array.forEach(function(obj) {
			map[obj] = true;
		});
		
		array = [];
		for (var obj in map) {
			array.push(obj);
		}
		
		return array;
	}
		
	utils.log = function()
	{
		var argumentsArray = Array.prototype.slice.call(arguments);
		
		if (window.HAS_BRIDGE) {
			bridge.send('log', argumentsArray.join(' '));
		}
		else {
			console.log.apply(console, argumentsArray);
		}
	};
	
	window.utils = utils;
})();