(function(){
	// Only initialize once
	if (typeof window === "undefined" || typeof window.__MyJS__ !== "undefined") {
		return;
	}
	
	var bridge = {};
	
	// Message replies
	var replyTokenCounter = 0;
	var pendingReplyMap = {};
	
	bridge.processMsgSendReply = function(reply) {
		if (reply) {
			var token = reply["reply"];
			var result = reply["result"] || null;
			if (token) {
				
				var callback = pendingReplyMap[token];
				if (callback) {
					callback(result);
					delete pendingReplyMap[token];
				}
				else {
					console.log("MRJS.processMsgSendReply received a message not corresponding to any pending returns: " + reply);
				}
			}
		}
	};
	
	// Base class definition
	var __MyJSBridgedObject = function(ptr) {
		this.ptr = ptr;
	};
	
	__MyJSBridgedObject.prototype.__bridgedObject_msgSend = function(name, args, callback) {
		try {
			if (callback) {
				replyTokenCounter += 1;
				var token = replyTokenCounter;
				pendingReplyMap[token] = callback;
				GENERATED_MSG_SEND({ "self": this.ptr, "cmd": name || "", "args": args, "reply": token });
			}
			else {
				GENERATED_MSG_SEND({ "self": this.ptr, "cmd": name || "", "args": args});
			}
		} catch (error) { console.log("Failed to send message: " + error); }
	};
	
	// Generated class definitions
	/*GENERATED_INIT*/
	
	window.__MyJS__ = bridge;
})();
