var Showdown = loadLibrary('showdown').Showdown;

action.titleWithContext = function(context, outError) {
	if (context.selectedRanges[0].length > 0) {
		return '@selection';
	} else {
		return null;
	}
};

action.performWithContext = function(context, outError) {
	// Default to the whole document
	var range = new Range(0, context.string.length);
	// If there is a selection, use that instead
	if (context.selectedRanges[0].length > 0) {
		range = context.selectedRanges[0];
	}
	// Grab our text, and convert it
	var text = context.substringWithRange(range);
	var converter = new Showdown.converter();
	var html = converter.makeHtml(text);
	// Create text recipe, add new text
	var recipe = new CETextRecipe();
	recipe.replaceRange(range, html);
	// Apply our text recipe!
	return context.applyTextRecipe(recipe);
};