const Declaration = require('../declaration');

class MaskBorder extends Declaration {

    /**
     * Return property name by final spec
     */
    normalize() {
        return this.name.replace('box-image', 'border');
    }

    /**
     * Return flex property for 2012 spec
     */
    prefixed(prop, prefix) {
        if (prefix === '-webkit-') {
            return super.prefixed(prop, prefix).replace('border', 'box-image');
        } else {
            return super.prefixed(prop, prefix);
        }
    }

}

MaskBorder.names = ['mask-border', 'mask-border-source', 'mask-border-slice', 'mask-border-width', 'mask-border-outset', 'mask-border-repeat', 'mask-box-image', 'mask-box-image-source', 'mask-box-image-slice', 'mask-box-image-width', 'mask-box-image-outset', 'mask-box-image-repeat'];
module.exports = MaskBorder;