var autoprefixer = require('autoprefixer');
var postcss      = require('postcss');

compiler.compileWithContextAsync = function(context, async)
{
 	var css = context.text;
 	postcss([ autoprefixer ]).process(css).then(function (result) {
 	    result.warnings().forEach(function (warn) {
 	        console.warn(warn.toString());
 	    });
 	    
 	    context.didCompileToText(result.css);
 	    async.finish();
 	}).catch((error) => {
		context.didFailWithError(EBCompilerErrorUnknown, ""+error, {});
		async.finish();
 	});
};
