/**
 * Automatically inserts a horizontal rule
 */

var nonEmptyLineRegex = /\S/;

action.canPerformWithContext = function(context, outError) {
	// Only allow this action if we are at the beginning of a line, and there is a line without text above us
	var location = context.selectedRanges[0].location,
		lineStart = context.lineStorage.lineRangeForIndex(location).location,
		prevLine = (lineStart > 1 ? context.substringWithRange(context.lineStorage.lineRangeForIndex(lineStart - 1)) : '');
	return (lineStart === (location - 1) || lineStart === location) && !nonEmptyLineRegex.test(prevLine);
};

action.performWithContext = function(context, outError) {
	// Insert our snippet!
	return context.insertTextSnippet(new CETextSnippet(action.setup.snippet));
};
