/**
 * Updates the numbers for an existing ordered list
 */
	
function isSameZone(zone1, zone2) {
	return zone1.range.location === zone2.range.location && zone1.range.length === zone2.range.length;
}

var isListSelector = new SXSelector('list.element.ordered, list.element.ordered *');

action.canPerformWithContext = function(context, outError) {
	return isListSelector.matches(context.syntaxTree.zoneAtCharacterIndex(context.selectedRanges[0].location));
};

action.performWithContext = function(context, outError) {
	var zone = context.syntaxTree.zoneAtCharacterIndex(context.selectedRanges[0].location),
		orderedSelector = new SXSelector('list.element.ordered');
	// Make sure our zone is the whole list element
	while (!orderedSelector.matches(zone)) {
		zone = zone.parent;
	}
	
	// Find our zone within its parent
	var parentZone = zone.parent,
		zoneIndex = 0;
	while (zoneIndex < parentZone.childCount && !isSameZone(parentZone.childAtIndex(zoneIndex), zone)) {
		zoneIndex++;
	}
	
	if (zoneIndex > 0) {
		// We now have our zone's index within its parent, but the ordered list might start earlier; work backwards until we find the first element
		do {
			zoneIndex--;
		} while (zoneIndex >= 0 && orderedSelector.matches(parentZone.childAtIndex(zoneIndex)));
		// Correct our zoneIndex (since based on the above logic we would have overshot by one)
		zoneIndex++;
	}
	
	// Now we can start updating our elements!
	var position = 1,
		recipe = new CETextRecipe(),
		markerZone, newMarker;
	while (parentZone.childAtIndex(zoneIndex) && orderedSelector.matches(parentZone.childAtIndex(zoneIndex))) {
		// Update the marker, if necessary
		markerZone = parentZone.childAtIndex(zoneIndex).childAtIndex(0);
		newMarker = position + '.';
		if (markerZone.text !== newMarker) {
			recipe.replaceRange(markerZone.range, newMarker);
		}
		// Increment our counters
		position++;
		zoneIndex++;
	}
	// Apply our changes!
	return context.applyTextRecipe(recipe);
};
